######################################
# Statistics for data science: R 
# 
# http://didawiki.di.unipi.it/doku.php/mds/sds/
######################################

# [CTRL-Enter] to execute a line

###### Script Lesson 10: Moments, functions of random variables ##########

# positive skewness and platykurtic
x = rbinom(10000, 50, 0.1)
plot(table(x)/length(x), type='p')
mu = mean(x) # sample mean
sigma = sd(x) # sample sd
mu3 = mean((x-mu)^3)/sigma^3 # sample skewness
mu3
# or using a library
library(moments)
skewness(x)
kurtosis(x)

# set working dir to current source file
# install.packages("rstudioapi")
setwd(dirname(rstudioapi::getActiveDocumentContext()$path))
# Data from Human Mortality Database https://www.mortality.org (require registration)
#library(HMDHFDplus)
#mortalitycount = readHMDweb(CNTRY='ITA', item='Deaths_1x1', username='<username>', password='<pwd>')
#save(mortalitycount, file="smd11.Rdata")
load(file="sds10.Rdata")
View(mortalitycount)

# negative skewness and leptokurtic
year = 2015
ndeaths = mortalitycount[mortalitycount$Year==year,]$Total
ages = mortalitycount[mortalitycount$Year==year,]$Age
plot(ages, ndeaths)
x = rep(ages, ndeaths) # sample from counts
mean(x)
plot(table(x)/length(x), xlab="ages", ylab="pmf")
skewness(x)
kurtosis(x)
